define(['angular', 'angularMocks', 'SudController', 'angularUiRouter'], function(angular, mocks) {
    'use strict';

    var contentResponse = {
        "object-type": "StaffUserDisclaimerContent",
        "date": "06/12/2014 08:56:42",
        "content": "abc (&quot;VA&quot;)WEB & MOBILE USER DISCLAIMER (UD) FOR VA EMPLOYEES<p>By agreeing to have any of VA’s software products delivered by web and mobile technology to your Government Furnished Equipment (GFE) or personal device and by subsequent use of the Licensto terminate thiintenance or updating of the provided Licensed Software, nor for correction of any errors in the Licensed Software. &nbsp;As a VA employee you are responsible for ensuring the Licensed Software is updated, as appropriate.</li><li>If any provision of this Agreement is held to be invalid or unenforceable the remaining provisions will not be affected.</li></ol>"
    };

    describe("The Sud controller", function (){

        var $controller,
          $scope,
          sudServiceMock,
          pageServiceMock,
          focusServiceMock,
          $log,
          $httpBackend;

        beforeEach( function () {
            module('angularTemplateApp');

            sudServiceMock = jasmine.createSpyObj('sudService', ['accept', 'getContent']);
            pageServiceMock = jasmine.createSpyObj('pageService', ['redirectToLaunchpad']);
            focusServiceMock = jasmine.createSpyObj('focusService', ['focusMain']);

            module(function($provide){
                $provide.value('sudService', sudServiceMock);
                $provide.value('pageService', pageServiceMock);
                $provide.value('focusService', focusServiceMock);
            });

            sudServiceMock.getContent.andReturn({
                then: function (callback) {
                    return callback(contentResponse);
                },
                catch: function (callback) {
                    return callback();
                }
            });

            inject(function($rootScope, _$controller_, _$httpBackend_, _$log_) {
                $scope = $rootScope.$new();
                $httpBackend = _$httpBackend_;
                $log = _$log_;
                $controller = _$controller_('SudController', {$scope: $scope, $log:$log});
            });
        });

        describe("when accept button is clicked", function (){
            beforeEach( function () {
                $scope.acceptClicked();
            });

            it ("should display content", function() {
                // expect(pageServiceMock.redirectToLaunchpad).toHaveBeenCalled();
            });
        });

        describe("when decline button is clicked", function (){
            beforeEach( function () {
                $scope.declineClicked();
            });

            it ("should call the global function to redirect to launchpad", function() {
                expect(pageServiceMock.redirectToLaunchpad).toHaveBeenCalled();
            });
        });
    });
});